SET TERM ^ ;



CREATE OR ALTER TRIGGER PROCESSOS_MI_STATUS FOR PROCESSOS_MINERAR
ACTIVE AFTER INSERT OR UPDATE POSITION 30
AS
DECLARE VARIABLE STR_PROCESSO VARCHAR(25);
DECLARE VARIABLE STR_SEQ_RECURSO VARCHAR(5);
DECLARE VARIABLE INT_SEQ_RECURSO INTEGER;
BEGIN
  /* Trigger text */

  STR_PROCESSO = NULL;
  STR_SEQ_RECURSO = NULL;
  INT_SEQ_RECURSO = NULL;

  IF ((NEW.STATUS IS DISTINCT FROM OLD.STATUS) AND
      (NEW.STATUS = 3) AND
      (NEW.PROCESSO IS NOT NULL) AND
      (UPPER(NEW.OBS) = 'SEGREDO DE JUSTIÇA')) THEN
  BEGIN
    IF (CHAR_LENGTH(NEW.PROCESSO) = 25) THEN
    BEGIN
      STR_PROCESSO = NEW.PROCESSO;
    END
    ELSE
    IF (CHAR_LENGTH(NEW.PROCESSO) > 25) THEN
    BEGIN
      STR_PROCESSO = SUBSTRING(NEW.PROCESSO FROM 1 FOR 25);
      STR_SEQ_RECURSO = SUBSTRING(NEW.PROCESSO FROM 27 FOR 5);
      INT_SEQ_RECURSO = CAST(:STR_SEQ_RECURSO AS INTEGER);
    END

    IF (:STR_PROCESSO IS NOT NULL) THEN
    BEGIN
      IF (:INT_SEQ_RECURSO IS NULL) THEN
      BEGIN
        UPDATE PUBLICACOES
        SET PUBLICACOES.SENHA_PUBLICACOES = 1
        WHERE PUBLICACOES.COD_DADOS IS NULL AND
              PUBLICACOES.DATA_BAIXA IS NULL AND
              PUBLICACOES.PROCESSO = :STR_PROCESSO AND
              PUBLICACOES.SEQ_RECURSO IS NULL AND
              ((PUBLICACOES.SENHA_PUBLICACOES IS NULL) OR (PUBLICACOES.SENHA_PUBLICACOES = 0));
      END
      ELSE
      IF (:INT_SEQ_RECURSO > 0) THEN
      BEGIN
        UPDATE PUBLICACOES
        SET PUBLICACOES.SENHA_PUBLICACOES = 1
        WHERE PUBLICACOES.COD_DADOS IS NULL AND
              PUBLICACOES.DATA_BAIXA IS NULL AND
              PUBLICACOES.PROCESSO = :STR_PROCESSO AND
              PUBLICACOES.SEQ_RECURSO = :INT_SEQ_RECURSO AND
              ((PUBLICACOES.SENHA_PUBLICACOES IS NULL) OR (PUBLICACOES.SENHA_PUBLICACOES = 0));

        UPDATE PUBLICACOES
        SET PUBLICACOES.SENHA_PUBLICACOES = 1
        WHERE PUBLICACOES.COD_DADOS IS NULL AND
              PUBLICACOES.DATA_BAIXA IS NULL AND
              PUBLICACOES.PROCESSO = NEW.PROCESSO AND
              ((PUBLICACOES.SENHA_PUBLICACOES IS NULL) OR (PUBLICACOES.SENHA_PUBLICACOES = 0));
      END
    END
  END
END
^
SET TERM ; ^
